/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.data;

import edu.mit.jverbnet.data.IFrame;
import edu.mit.jverbnet.data.IMember;
import edu.mit.jverbnet.data.IThematicRole;
import edu.mit.jverbnet.data.IVerbClass;
import edu.mit.jverbnet.util.Checks;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerbClass
implements IVerbClass {
    private final String id;
    private final List<IMember> members;
    private final List<IThematicRole> roles;
    private final List<IFrame> frames;
    private final List<IVerbClass> subclasses;
    private boolean isParentSet = false;
    private IVerbClass parent = null;

    public VerbClass(String id, List<IMember.IMemberBuilder> memberBs, List<IThematicRole.IThematicRoleBuilder> roleBs, List<IFrame.IFrameBuilder> frameBs, List<IVerbClass> subclasses) {
        id = Checks.NotEmptyOrBlank.check("id", id);
        Checks.minSizeAndNotNull(1).check("builders", memberBs);
        Checks.minSizeAndNotNull(1).check("roles", roleBs);
        Checks.minSizeAndNotNull(1).check("frames", frameBs);
        memberBs = Checks.allElementsAre(Checks.NotNull, "builders", memberBs, null);
        roleBs = Checks.allElementsAre(Checks.NotNull, "roles", roleBs, null);
        frameBs = Checks.allElementsAre(Checks.NotNull, "frames", frameBs, null);
        subclasses = Checks.allElementsAre(Checks.NotNull, "subclasses", subclasses, Checks.UnmodifiableMaskNullWithEmpty);
        LinkedList<IMember> members = new LinkedList<IMember>();
        LinkedList<IThematicRole> roles = new LinkedList<IThematicRole>();
        LinkedList<IFrame> frames = new LinkedList<IFrame>();
        for (IMember.IMemberBuilder iMemberBuilder : memberBs) {
            members.add(iMemberBuilder.create(this));
        }
        for (IThematicRole.IThematicRoleBuilder iThematicRoleBuilder : roleBs) {
            roles.add(iThematicRoleBuilder.create(this));
        }
        for (IFrame.IFrameBuilder iFrameBuilder : frameBs) {
            frames.add(iFrameBuilder.create(this));
        }
        for (IVerbClass iVerbClass : subclasses) {
            iVerbClass.setParent(this);
        }
        this.id = id;
        this.members = Checks.UnmodifiableMaskNullWithEmpty.reallocate(members);
        this.roles = Checks.UnmodifiableMaskNullWithEmpty.reallocate(roles);
        this.frames = Checks.UnmodifiableMaskNullWithEmpty.reallocate(frames);
        this.subclasses = subclasses;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public IVerbClass getParent() {
        this.checkParentSet(true);
        return this.parent;
    }

    @Override
    public boolean isRoot() {
        this.checkParentSet(true);
        return this.parent == null;
    }

    @Override
    public synchronized void setParent(IVerbClass parent) {
        this.checkParentSet(false);
        this.isParentSet = true;
        this.parent = parent;
    }

    protected void checkParentSet(boolean expectedValue) {
        if (this.isParentSet != expectedValue) {
            throw new IllegalStateException("Parent is " + (this.isParentSet ? "already" : "not") + " set");
        }
    }

    @Override
    public List<IMember> getMembers() {
        return this.members;
    }

    @Override
    public List<IThematicRole> getThematicRoles() {
        return this.roles;
    }

    @Override
    public List<IFrame> getFrames() {
        return this.frames;
    }

    @Override
    public List<IVerbClass> getSubclasses() {
        return this.subclasses;
    }
}

