/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.data;

import edu.mit.jverbnet.data.IWordnetKey;
import edu.mit.jverbnet.util.Checks;

public class WordnetKey
implements IWordnetKey {
    private final String lemma;
    private final int lexID;
    private final int lexFileNum;

    public WordnetKey(String lemma, int lexFileNum, int lexID) {
        lemma = Checks.NotNullEmptyOrBlank.check("lemma", lemma);
        if (lexFileNum < 0 || lexFileNum > 99) {
            throw new IllegalArgumentException("lexical file number is out of range: " + lexFileNum);
        }
        if (lexID < 0 || lexID > 15) {
            throw new IllegalArgumentException("lexical id is out of range: " + lexID);
        }
        this.lemma = lemma;
        this.lexFileNum = lexFileNum;
        this.lexID = lexID;
    }

    public String getLemma() {
        return this.lemma;
    }

    public int getSynsetType() {
        return 2;
    }

    public int getLexicalFileNumber() {
        return this.lexFileNum;
    }

    public int getLexicalID() {
        return this.lexID;
    }

    public int compareTo(IWordnetKey key) {
        int cmp = this.getLemma().compareTo(key.getLemma());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Float.compare(this.getSynsetType(), key.getSynsetType());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Float.compare(this.getLexicalFileNumber(), key.getLexicalFileNumber());
        if (cmp != 0) {
            return cmp;
        }
        return Float.compare(this.getLexicalID(), key.getLexicalID());
    }

    public String toString() {
        return WordnetKey.toString(this);
    }

    public int hashCode() {
        return WordnetKey.hashCode(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WordnetKey)) {
            return false;
        }
        WordnetKey other = (WordnetKey)obj;
        if (!this.lemma.equals(other.getLemma())) {
            return false;
        }
        if (this.lexID != other.getLexicalID()) {
            return false;
        }
        if (2 != other.getSynsetType()) {
            return false;
        }
        return this.lexFileNum == other.getLexicalFileNumber();
    }

    public static int hashCode(IWordnetKey key) {
        int prime = 31;
        int result = 1;
        result = 31 * result + key.getLemma().hashCode();
        result = 31 * result + key.getLexicalID();
        result = 31 * result + key.getSynsetType();
        result = 31 * result + key.getLexicalFileNumber();
        return result;
    }

    public static String toString(IWordnetKey key) {
        StringBuilder sb = new StringBuilder(key.getLemma().length() + 8);
        String lexID = Integer.toString(key.getLexicalID());
        String lexFileNum = Integer.toString(key.getLexicalFileNumber());
        sb.append(key.getLemma().toLowerCase());
        sb.append('%');
        sb.append(key.getSynsetType());
        sb.append(':');
        if (lexFileNum.length() < 2) {
            sb.append('0');
        }
        sb.append(lexFileNum);
        sb.append(':');
        if (lexID.length() < 2) {
            sb.append('0');
        }
        sb.append(lexID);
        return sb.toString();
    }

    public static WordnetKey parseKey(String key) {
        key = Checks.NotNullEmptyOrBlank.check("key", key);
        int begin = 0;
        int end = 0;
        end = key.indexOf(37);
        String lemma = key.substring(begin, end);
        begin = end + 1;
        end = begin + 1;
        begin = end + 1;
        end = begin + 2;
        int lexFileNum = Integer.parseInt(key.substring(begin, end));
        begin = end + 1;
        end = begin + 2;
        int lexID = Integer.parseInt(key.substring(begin, end));
        if (end != key.length()) {
            throw new IllegalArgumentException("wordnet key has extraneous trailing characters '" + key.substring(end, key.length()) + "'");
        }
        return new WordnetKey(lemma, lexFileNum, lexID);
    }
}

