/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.parse;

import edu.mit.jverbnet.data.VerbnetTypes;
import edu.mit.jverbnet.data.semantics.ArgType;
import edu.mit.jverbnet.data.semantics.ISemanticArgType;
import edu.mit.jverbnet.util.Checks;
import edu.mit.jverbnet.util.parse.IHasParserHandler;
import edu.mit.jverbnet.util.parse.MappedHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgHandler
extends MappedHandler<ISemanticArgType> {
    public static final String XML_TAG_ARGS = "ARGS";
    public static final String XML_TAG_ARG = "ARG";
    private ISemanticArgType semArgType = null;

    public ArgHandler() {
        this((XMLReader)null, (ContentHandler)null);
    }

    public ArgHandler(IHasParserHandler parent) {
        this(parent == null ? null : parent.getParser(), parent);
    }

    public ArgHandler(XMLReader parser) {
        this(parser, (ContentHandler)null);
    }

    public ArgHandler(XMLReader parser, ContentHandler parent) {
        super(parser, parent, XML_TAG_ARG);
    }

    @Override
    protected void clearLocal() {
        this.semArgType = null;
    }

    @Override
    public void startTaggedBlock(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        String argTypeStr = attrs.getValue("type");
        ArgType argType = ArgType.getById(argTypeStr);
        String subclassId = attrs.getValue("value");
        Checks.NotNull.check("argType", argType);
        Checks.NotNullEmptyOrBlank.check("subclassId", subclassId);
        if (argType == null) {
            throw new NullPointerException("Unknown value '" + argTypeStr + "' for " + ArgType.class.getSimpleName());
        }
        this.semArgType = VerbnetTypes.getById(argType.getSubclassType(), subclassId);
        if (this.semArgType == null) {
            throw new NullPointerException("Unknown value '" + subclassId + "' for " + argType.getSubclassType().getSimpleName());
        }
    }

    @Override
    public ISemanticArgType doGetElement() {
        return this.semArgType;
    }
}

