/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Checks {
    public static final String genericVarName = "the variable";
    public static final Mask<Object> NotNull = new Mask<Object>(false){

        @Override
        public <T> boolean is(T value) {
            return value != null;
        }

        @Override
        public <T> T check(String varName, T value) {
            if (value == null) {
                throw new NullPointerException(Checks.normalizeVarName(varName) + " may not be null");
            }
            return value;
        }
    };
    public static final Mask<Object> IsNull = new Mask<Object>(true){

        @Override
        public <T> boolean is(T value) {
            return value == null;
        }

        @Override
        public <T> T check(String varName, T value) {
            if (value != null) {
                throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " must be null");
            }
            return null;
        }
    };
    public static final Mask<String> IsEmpty = new Mask<String>(false){

        @Override
        public <T extends String> boolean is(T value) {
            return value != null && value.length() == 0;
        }

        @Override
        public <T extends String> T check(String varName, T value) {
            if (value == null) {
                throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " must be empty (it is null)");
            }
            if (value.length() != 0) {
                throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " must be empty (its value is '" + value + "')");
            }
            return value;
        }
    };
    public static final Mask<String> IsBlank = new Mask<String>(false){

        @Override
        public <T extends String> boolean is(T value) {
            return value != null && value.length() > 0 && value.trim().length() == 0;
        }

        @Override
        public <T extends String> T check(String varName, T value) {
            if (value == null) {
                throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " must be all whitespace (it is null)");
            }
            if (value.length() == 0) {
                throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " must be all whitespace (it is empty)");
            }
            if (value.trim().length() != 0) {
                throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " must be all whitespace (its value is '" + value + "')");
            }
            return value;
        }
    };
    public static final Mask<String> IsNullOrEmpty = new Mask<String>(true){

        @Override
        public <T extends String> boolean is(T value) {
            return value == null || value.length() == 0;
        }

        @Override
        public <T extends String> T check(String varName, T value) {
            if (value == null) {
                return value;
            }
            if (value.length() == 0) {
                return value;
            }
            if (value.trim().length() == 0) {
                throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " must be null or empty (it is all whitespace");
            }
            throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " must be null or empty (its value is '" + value + "')");
        }
    };
    public static final Mask<String> IsNullOrBlank = new Mask<String>(true){

        @Override
        public <T extends String> boolean is(T value) {
            return value == null || value.length() != 0 && value.trim().length() == 0;
        }

        @Override
        public <T extends String> T check(String varName, T value) {
            if (value == null) {
                return value;
            }
            if (value.length() == 0) {
                throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " must be null or all whitespace (it is empty)");
            }
            if (value.trim().length() != 0) {
                throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " must be null or all whitespace (its value is '" + value + "')");
            }
            return value;
        }
    };
    public static final Mask<String> IsEmptyOrBlank = new Mask<String>(false){

        @Override
        public <T extends String> boolean is(T value) {
            if (value == null) {
                return false;
            }
            if (value.length() == 0) {
                return true;
            }
            return value.trim().length() == 0;
        }

        @Override
        public <T extends String> T check(String varName, T value) {
            if (value == null) {
                throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " must be empty or all whitespace (it is null)");
            }
            if (value.trim().length() != 0) {
                throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " must be empty or all whitespace (its value is '" + value + "')");
            }
            return value;
        }
    };
    public static final Mask<String> IsNullEmptyOrBlank = new Mask<String>(true){

        @Override
        public <T extends String> boolean is(T value) {
            if (value == null) {
                return true;
            }
            return value.trim().length() == 0;
        }

        @Override
        public <T extends String> T check(String varName, T value) {
            if (value == null) {
                return value;
            }
            if (value.trim().length() == 0) {
                return value;
            }
            throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " must be null, empty or all whitespace (its value is '" + value + "')");
        }
    };
    public static final Mask<String> NotEmpty = new Mask<String>(true){

        @Override
        public <T extends String> boolean is(T value) {
            return !IsEmpty.is(value);
        }

        @Override
        public <T extends String> T check(String varName, T value) {
            if (value == null) {
                return value;
            }
            if (value.length() != 0) {
                return (T)value.trim();
            }
            throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " may not be empty");
        }
    };
    public static final Mask<String> NotBlank = new Mask<String>(true){

        @Override
        public <T extends String> boolean is(T value) {
            return !IsBlank.is(value);
        }

        @Override
        public <T extends String> T check(String varName, T value) {
            if (value == null) {
                return (T)value;
            }
            if (((String)value).length() == 0) {
                return (T)value;
            }
            if (((String)(value = ((String)value).trim())).length() != 0) {
                return (T)value;
            }
            throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " may not be all whitespace");
        }
    };
    public static final Mask<String> NotNullOrEmpty = new Mask<String>(false){

        @Override
        public <T extends String> boolean is(T value) {
            return !IsNullOrEmpty.is(value);
        }

        @Override
        public <T extends String> T check(String varName, T value) {
            if (value == null) {
                throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " may not be null or empty (it is null)");
            }
            if (value.length() == 0) {
                throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " may not be null or empty (it is empty)");
            }
            return (T)value.trim();
        }
    };
    public static final Mask<String> NotNullOrBlank = new Mask<String>(false){

        @Override
        public <T extends String> boolean is(T value) {
            return !IsNullOrBlank.is(value);
        }

        @Override
        public <T extends String> T check(String varName, T value) {
            if (value == null) {
                throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " may not be null or all whitespace (it is null)");
            }
            String trimmed = value.trim();
            if (value.length() != 0 && trimmed.length() == 0) {
                throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " may not be null or all whitespace (it is " + (value == null ? "null" : "empty") + ")");
            }
            return (T)trimmed;
        }
    };
    public static final Mask<String> NotEmptyOrBlank = new Mask<String>(true){

        @Override
        public <T extends String> boolean is(T value) {
            return !IsEmptyOrBlank.is(value);
        }

        @Override
        public <T extends String> T check(String varName, T value) {
            if (value == null) {
                return value;
            }
            if (value.length() == 0) {
                throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " may not be empty or all whitespace (it is empty)");
            }
            String trimmed = value.trim();
            if (trimmed.length() == 0) {
                throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " may not be empty or all whitespace (it is all whitespace)");
            }
            return (T)trimmed;
        }
    };
    public static final Mask<String> NotNullEmptyOrBlank = new Mask<String>(false){

        @Override
        public <T extends String> boolean is(T value) {
            return !IsNullEmptyOrBlank.is(value);
        }

        @Override
        public <T extends String> T check(String varName, T value) {
            varName = Checks.normalizeVarName(varName);
            if (value == null) {
                throw new IllegalArgumentException(varName + " may not be empty or all whitespace (it is null)");
            }
            if (((String)value).length() == 0) {
                throw new IllegalArgumentException(varName + " may not be empty or all whitespace (it is empty)");
            }
            if (((String)(value = ((String)value).trim())).length() == 0) {
                throw new IllegalArgumentException(varName + " may not be empty or all whitespace (it is all whitespace)");
            }
            return (T)value;
        }
    };
    public static final Mask<Collection<?>> IsEmptyCol = new Mask<Collection<?>>(true){

        @Override
        public <T extends Collection<?>> boolean is(T value) {
            if (value == null) {
                return false;
            }
            return value.isEmpty();
        }

        @Override
        public <T extends Collection<?>> T check(String varName, T value) {
            if (value == null) {
                throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " collection must not be null");
            }
            if (!value.isEmpty()) {
                throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " collection must be empty (it has " + value.size() + " elements)");
            }
            return value;
        }
    };
    public static final Mask<Collection<?>> IsNullOrEmptyCol = new Mask<Collection<?>>(false){

        @Override
        public <T extends Collection<?>> boolean is(T value) {
            if (value == null) {
                return true;
            }
            return value.isEmpty();
        }

        @Override
        public <T extends Collection<?>> T check(String varName, T value) {
            if (!this.is(value)) {
                throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " collection must be null or empty (it has " + value.size() + " elements)");
            }
            return value;
        }
    };
    public static final Mask<Collection<?>> NotEmptyCol = new Mask<Collection<?>>(true){

        @Override
        public <T extends Collection<?>> boolean is(T value) {
            return !IsEmptyCol.is(value);
        }

        @Override
        public <T extends Collection<?>> T check(String varName, T value) {
            if (this.is(value)) {
                throw new IllegalArgumentException("The collection may not be empty");
            }
            return value;
        }
    };
    public static final Mask<Collection<?>> NotNullOrEmptyCol = new Mask<Collection<?>>(false){

        @Override
        public <T extends Collection<?>> boolean is(T value) {
            return !IsNullOrEmptyCol.is(value);
        }

        @Override
        public <T extends Collection<?>> T check(String varName, T value) {
            if (value == null) {
                throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " collection may not be null or empty (it is null)");
            }
            if (value.isEmpty()) {
                throw new IllegalArgumentException(Checks.normalizeVarName(varName) + " collection may not be null or empty (it is empty)");
            }
            return value;
        }
    };
    private static final int MAX_ENTRIES = 128;
    private static final Map<Integer, IsMinSizeAndNotNull> minSizeMap = new LinkedHashMap<Integer, IsMinSizeAndNotNull>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, IsMinSizeAndNotNull> eldest) {
            return this.size() > 128;
        }
    };
    private static final Map<Integer, IsMaxSizeAndNotNull> maxSizeMap = new LinkedHashMap<Integer, IsMaxSizeAndNotNull>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, IsMaxSizeAndNotNull> eldest) {
            return this.size() > 128;
        }
    };
    public static final IReallocationStrategy DoNotReallocate = new IReallocationStrategy(){

        @Override
        public <T> List<T> reallocate(List<T> list) {
            return list;
        }

        @Override
        public <T> Set<T> reallocate(Set<T> set) {
            return set;
        }

        @Override
        public <T> SortedSet<T> reallocate(SortedSet<T> set) {
            return set;
        }

        @Override
        public <K, V> Map<K, V> reallocate(Map<K, V> map) {
            return map;
        }

        @Override
        public <K, V> SortedMap<K, V> reallocate(SortedMap<K, V> map) {
            return map;
        }
    };
    public static final IReallocationStrategy ModifiableLeaveNulls = new IReallocationStrategy(){

        @Override
        public <T> List<T> reallocate(List<T> list) {
            if (list == null) {
                return null;
            }
            return new ArrayList<T>(list);
        }

        @Override
        public <T> Set<T> reallocate(Set<T> set) {
            if (set == null) {
                return null;
            }
            return new HashSet<T>(set);
        }

        @Override
        public <T> SortedSet<T> reallocate(SortedSet<T> set) {
            if (set == null) {
                return null;
            }
            return new TreeSet<T>(set);
        }

        @Override
        public <K, V> Map<K, V> reallocate(Map<K, V> map) {
            if (map == null) {
                return null;
            }
            return new HashMap<K, V>(map);
        }

        @Override
        public <K, V> SortedMap<K, V> reallocate(SortedMap<K, V> map) {
            if (map == null) {
                return null;
            }
            return new TreeMap<K, V>(map);
        }
    };
    public static final IReallocationStrategy UnmodifiableLeaveNulls = new IReallocationStrategy(){

        @Override
        public <T> List<T> reallocate(List<T> list) {
            if (list == null) {
                return null;
            }
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            if (list.size() == 1) {
                return Collections.singletonList(list.iterator().next());
            }
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }

        @Override
        public <T> Set<T> reallocate(Set<T> set) {
            if (set == null) {
                return null;
            }
            if (set.isEmpty()) {
                return Collections.emptySet();
            }
            if (set.size() == 1) {
                return Collections.singleton(set.iterator().next());
            }
            return Collections.unmodifiableSet(new HashSet<T>(set));
        }

        @Override
        public <T> SortedSet<T> reallocate(SortedSet<T> set) {
            if (set == null) {
                return null;
            }
            return Collections.unmodifiableSortedSet(new TreeSet<T>(set));
        }

        @Override
        public <K, V> Map<K, V> reallocate(Map<K, V> map) {
            if (map == null) {
                return null;
            }
            if (map.isEmpty()) {
                return Collections.emptyMap();
            }
            if (map.size() == 1) {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                return Collections.singletonMap(e.getKey(), e.getValue());
            }
            return Collections.unmodifiableMap(new HashMap<K, V>(map));
        }

        @Override
        public <K, V> SortedMap<K, V> reallocate(SortedMap<K, V> map) {
            if (map == null) {
                return null;
            }
            return Collections.unmodifiableSortedMap(new TreeMap<K, V>(map));
        }
    };
    public static final IReallocationStrategy ModifiableMaskNullWithEmpty = new IReallocationStrategy(){

        @Override
        public <T> List<T> reallocate(List<T> list) {
            if (list == null) {
                return new ArrayList();
            }
            return new ArrayList<T>(list);
        }

        @Override
        public <T> Set<T> reallocate(Set<T> set) {
            if (set == null) {
                return new HashSet();
            }
            return new HashSet<T>(set);
        }

        @Override
        public <T> SortedSet<T> reallocate(SortedSet<T> set) {
            if (set == null) {
                return new TreeSet();
            }
            return new TreeSet<T>(set);
        }

        @Override
        public <K, V> Map<K, V> reallocate(Map<K, V> map) {
            if (map == null) {
                return new HashMap();
            }
            return new HashMap<K, V>(map);
        }

        @Override
        public <K, V> SortedMap<K, V> reallocate(SortedMap<K, V> map) {
            if (map == null) {
                return new TreeMap();
            }
            return new TreeMap<K, V>(map);
        }
    };
    public static final IReallocationStrategy UnmodifiableMaskNullWithEmpty = new IReallocationStrategy(){

        @Override
        public <T> List<T> reallocate(List<T> list) {
            if (list == null || list.isEmpty()) {
                return Collections.emptyList();
            }
            if (list.size() == 1) {
                return Collections.singletonList(list.iterator().next());
            }
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }

        @Override
        public <T> Set<T> reallocate(Set<T> set) {
            if (set == null || set.isEmpty()) {
                return Collections.emptySet();
            }
            if (set.size() == 1) {
                return Collections.singleton(set.iterator().next());
            }
            return Collections.unmodifiableSet(new HashSet<T>(set));
        }

        @Override
        public <T> SortedSet<T> reallocate(SortedSet<T> set) {
            if (set == null) {
                Collections.unmodifiableSortedSet(new TreeSet());
            }
            return Collections.unmodifiableSortedSet(new TreeSet<T>(set));
        }

        @Override
        public <K, V> Map<K, V> reallocate(Map<K, V> map) {
            if (map == null || map.isEmpty()) {
                return Collections.emptyMap();
            }
            if (map.size() == 1) {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                return Collections.singletonMap(e.getKey(), e.getValue());
            }
            return Collections.unmodifiableMap(new HashMap<K, V>(map));
        }

        @Override
        public <K, V> SortedMap<K, V> reallocate(SortedMap<K, V> map) {
            if (map == null) {
                return Collections.unmodifiableSortedMap(new TreeMap());
            }
            return Collections.unmodifiableSortedMap(new TreeMap<K, V>(map));
        }
    };

    public static String normalizeVarName(String varName) {
        if (varName == null) {
            return genericVarName;
        }
        if ((varName = varName.trim()).length() == 0) {
            return genericVarName;
        }
        return varName;
    }

    public static <T> Mask<T> notNull() {
        return NotNull;
    }

    public static <T> Mask<T> isNull() {
        return IsNull;
    }

    public static String trim(ICondition<Object> test, String value) {
        if (test == null) {
            test = Checks.notNull();
        }
        if (test.allowsNulls()) {
            throw new IllegalArgumentException("The trim method may not use a condition that allow null");
        }
        return test.is(value) ? value.trim() : value;
    }

    public static String trimAndMask(ICondition<Object> test, String value, IMask<String> mask, String maskValue) {
        if (test == null) {
            test = Checks.notNull();
        }
        if (mask == null) {
            mask = Checks.isNull();
        }
        String trim = Checks.trim(test, value);
        return mask.mask(trim, maskValue);
    }

    public static String trimAndMaskNull(String value, String maskValue) {
        return Checks.trimAndMask(null, value, null, maskValue);
    }

    public static final Mask<Collection<?>> minSizeAndNotNull(int size) {
        IsMinSizeAndNotNull result = minSizeMap.get(size);
        if (result == null) {
            result = new IsMinSizeAndNotNull(size);
            minSizeMap.put(size, result);
        }
        return result;
    }

    public static final Mask<Collection<?>> maxSizeAndNotNull(int size) {
        IsMaxSizeAndNotNull result = maxSizeMap.get(size);
        if (result == null) {
            result = new IsMaxSizeAndNotNull(size);
            maxSizeMap.put(size, result);
        }
        return result;
    }

    public static <S, E extends S> List<E> allElementsAre(ICheck<S> test, String varName, List<E> list, IReallocationStrategy r) {
        if (r == null) {
            r = DoNotReallocate;
        }
        String eName = "element of " + varName;
        if (list != null) {
            for (E e : list) {
                test.check(eName, e);
            }
        }
        return r.reallocate(list);
    }

    public static <S, E extends S> Set<E> allElementsAre(ICheck<S> test, String varName, Set<E> set, IReallocationStrategy r) {
        if (r == null) {
            r = DoNotReallocate;
        }
        String eName = "element of " + varName;
        if (set != null) {
            for (E e : set) {
                test.check(eName, e);
            }
        }
        return r.reallocate(set);
    }

    public static <S, E extends S> SortedSet<E> allElementsAre(ICheck<S> test, String varName, SortedSet<E> set, IReallocationStrategy r) {
        if (r == null) {
            r = DoNotReallocate;
        }
        String eName = "element of " + varName;
        if (set != null) {
            for (Object e : set) {
                test.check(eName, e);
            }
        }
        return r.reallocate(set);
    }

    public static <S, K extends S, V> Map<K, V> allKeysAre(ICheck<S> test, String varName, Map<K, V> map, IReallocationStrategy r) {
        if (r == null) {
            r = DoNotReallocate;
        }
        if (map != null) {
            String kName = "key of " + varName;
            for (Map.Entry<K, V> e : map.entrySet()) {
                test.check(kName, e.getKey());
            }
        }
        return r.reallocate(map);
    }

    public static <S, K extends S, V> SortedMap<K, V> allKeysAre(ICheck<S> test, String varName, SortedMap<K, V> map, IReallocationStrategy r) {
        if (r == null) {
            r = DoNotReallocate;
        }
        if (map != null) {
            String kName = "key of " + varName;
            for (Map.Entry<K, V> e : map.entrySet()) {
                test.check(kName, e.getKey());
            }
        }
        return r.reallocate(map);
    }

    public static <S, K, V extends S> Map<K, V> allValuesAre(ICheck<S> test, String varName, Map<K, V> map, IReallocationStrategy r) {
        if (r == null) {
            r = DoNotReallocate;
        }
        if (map != null) {
            String vName = "value of " + varName;
            for (Map.Entry<K, V> e : map.entrySet()) {
                test.check(vName, e.getValue());
            }
        }
        return r.reallocate(map);
    }

    public static <S, K, V extends S> SortedMap<K, V> allValuesAre(ICheck<V> test, String varName, SortedMap<K, V> map, IReallocationStrategy r) {
        if (r == null) {
            r = DoNotReallocate;
        }
        if (map != null) {
            String vName = "value of " + varName;
            for (Map.Entry<K, V> e : map.entrySet()) {
                test.check(vName, e.getValue());
            }
        }
        return r.reallocate(map);
    }

    public static <S, K extends S, V extends S> Map<K, V> allKeysAndValuesAre(ICheck<S> test, String varName, Map<K, V> map, IReallocationStrategy r) {
        if (r == null) {
            r = DoNotReallocate;
        }
        if (map != null) {
            String kName = "key of " + varName;
            String vName = "value of " + varName;
            for (Map.Entry<K, V> e : map.entrySet()) {
                test.check(kName, e.getKey());
                test.check(vName, e.getValue());
            }
        }
        return r.reallocate(map);
    }

    public static <S, K extends S, V extends S> SortedMap<K, V> allKeysAndValuesAre(ICheck<S> test, String varName, SortedMap<K, V> map, IReallocationStrategy r) {
        if (r == null) {
            r = DoNotReallocate;
        }
        if (map != null) {
            String kName = "key of " + varName;
            String vName = "value of " + varName;
            for (Map.Entry<K, V> e : map.entrySet()) {
                test.check(kName, e.getKey());
                test.check(vName, e.getValue());
            }
        }
        return r.reallocate(map);
    }

    public static <T> T thisMethodShouldNeverBeCalled() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement target = null;
        for (StackTraceElement e : stackTrace) {
            if (Thread.class.getName().equals(e.getClassName()) || Check.class.getName().equals(e.getClassName())) continue;
            target = e;
            break;
        }
        throw new IllegalStateException("This method should never be called: " + (target == null ? "unknown" : target));
    }

    public static <T> T thisLineShouldNeverBeCalled() throws IllegalStateException {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement target = null;
        for (StackTraceElement e : stackTrace) {
            if (Thread.class.getName().equals(e.getClassName()) || Check.class.getName().equals(e.getClassName())) continue;
            target = e;
            break;
        }
        throw new IllegalStateException("This line should never be executed: " + (target == null ? "unknown" : target));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsMaxSizeAndNotNull
    extends Mask<Collection<?>> {
        private final int maxSize;

        private IsMaxSizeAndNotNull(int maxSize) {
            super(false);
            if (maxSize < 0) {
                maxSize = 0;
            }
            this.maxSize = maxSize;
        }

        @Override
        public <T extends Collection<?>> boolean is(T value) {
            if (value == null) {
                return false;
            }
            return value.size() <= this.maxSize;
        }

        @Override
        public <T extends Collection<?>> T check(String varName, T value) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsMinSizeAndNotNull
    extends Mask<Collection<?>> {
        private final int minSize;

        private IsMinSizeAndNotNull(int minSize) {
            super(false);
            if (minSize < 0) {
                minSize = 0;
            }
            this.minSize = minSize;
        }

        @Override
        public <T extends Collection<?>> boolean is(T value) {
            if (value == null) {
                return false;
            }
            return value.size() >= this.minSize;
        }

        @Override
        public <T extends Collection<?>> T check(String varName, T value) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Mask<S>
    extends Check<S>
    implements IMask<S> {
        public Mask(boolean allowsNulls) {
            super(allowsNulls);
        }

        @Override
        public <T extends S> T mask(T value, T mask) {
            return this.is(value) ? mask : value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Check<S>
    extends Condition<S>
    implements ICheck<S> {
        public Check(boolean allowsNulls) {
            super(allowsNulls);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Condition<S>
    implements ICondition<S> {
        private final boolean allowsNulls;

        public Condition(boolean allowsNulls) {
            this.allowsNulls = allowsNulls;
        }

        @Override
        public boolean allowsNulls() {
            return this.allowsNulls;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IReallocationStrategy {
        public <T> List<T> reallocate(List<T> var1);

        public <T> Set<T> reallocate(Set<T> var1);

        public <T> SortedSet<T> reallocate(SortedSet<T> var1);

        public <K, V> Map<K, V> reallocate(Map<K, V> var1);

        public <K, V> SortedMap<K, V> reallocate(SortedMap<K, V> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IMask<S>
    extends ICondition<S> {
        public <T extends S> T mask(T var1, T var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ICheck<S>
    extends ICondition<S> {
        public <T extends S> T check(String var1, T var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ICondition<S> {
        public <T extends S> boolean is(T var1);

        public boolean allowsNulls();
    }
}

