/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.util;

import edu.mit.jverbnet.util.Checks;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilteringIterator<E>
implements Iterator<E> {
    private final Iterator<E> backingItr;
    private E next;

    public FilteringIterator(Iterator<E> backingItr) {
        Checks.NotNull.check("backingItr", backingItr);
        this.backingItr = backingItr;
        this.advance();
    }

    protected void advance() {
        this.next = null;
        while (this.backingItr.hasNext()) {
            E element = this.backingItr.next();
            if (!this.include(element)) continue;
            this.next = element;
            break;
        }
    }

    protected abstract boolean include(E var1);

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public E next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        E result = this.next;
        this.advance();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

