/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.util.parse;

import edu.mit.jverbnet.util.Checks;
import edu.mit.jverbnet.util.parse.IHasParserHandler;
import edu.mit.jverbnet.util.parse.ITaggedBlockTaskHandler;
import edu.mit.jverbnet.util.parse.ITaggedHandler;
import java.util.AbstractList;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LazyForwardingHandler<T>
implements ITaggedHandler<T> {
    private final String tag;
    private final ForwardingTaskList blockTasks = new ForwardingTaskList();
    private boolean clearPending;
    private Locator locator;
    private XMLReader parser;
    private ContentHandler parent;
    private ITaggedHandler<T> backingHandler = null;

    public LazyForwardingHandler(String tag) {
        this(null, null, tag);
    }

    public LazyForwardingHandler(XMLReader parser, String tag) {
        this(parser, null, tag);
    }

    public LazyForwardingHandler(IHasParserHandler parent, String tag) {
        this(parent == null ? null : parent.getParser(), parent, tag);
    }

    public LazyForwardingHandler(XMLReader parser, ContentHandler parent, String tag) {
        tag = Checks.NotNullEmptyOrBlank.check("tag", tag);
        this.parser = parser;
        this.parent = parent;
        this.tag = tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ITaggedHandler<T> getBackingHandler() {
        if (this.backingHandler == null) {
            LazyForwardingHandler lazyForwardingHandler = this;
            synchronized (lazyForwardingHandler) {
                if (this.backingHandler == null) {
                    ITaggedHandler<T> backingHandler = this.createBackingHandler();
                    if (!backingHandler.getTag().equals(this.getTag())) {
                        throw new IllegalStateException("The backing handler does not have the same tag as the forwarding handler: forwarding tag='" + this.getTag() + "', backing tag='" + backingHandler.getTag() + "'");
                    }
                    backingHandler.setDocumentLocator(this.locator);
                    backingHandler.setParser(this.parser);
                    backingHandler.setParent(this.parent);
                    backingHandler.getTaggedBlockTasks().addAll(this.blockTasks.getInternalList());
                    if (this.clearPending) {
                        backingHandler.clear();
                    }
                    this.backingHandler = backingHandler;
                }
            }
        }
        return this.backingHandler;
    }

    protected abstract ITaggedHandler<T> createBackingHandler();

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        if (this.backingHandler != null) {
            this.backingHandler.setDocumentLocator(locator);
        }
    }

    @Override
    public XMLReader getParser() {
        return this.backingHandler == null ? this.parser : this.backingHandler.getParser();
    }

    @Override
    public void setParser(XMLReader parser) {
        this.parser = parser;
        if (this.backingHandler != null) {
            this.backingHandler.setParser(parser);
        }
    }

    @Override
    public String getTag() {
        return this.backingHandler == null ? this.tag : this.backingHandler.getTag();
    }

    @Override
    public ContentHandler getParent() {
        return this.backingHandler == null ? this.parent : this.backingHandler.getParent();
    }

    @Override
    public void setParent(ContentHandler parent) {
        this.parent = parent;
        if (this.backingHandler != null) {
            this.backingHandler.setParent(parent);
        }
    }

    @Override
    public List<ITaggedBlockTaskHandler> getTaggedBlockTasks() {
        return this.blockTasks;
    }

    @Override
    public void clear() {
        if (this.backingHandler == null) {
            this.clearPending = true;
        } else {
            this.backingHandler.clear();
        }
    }

    @Override
    public T getElement() {
        return this.getBackingHandler().getElement();
    }

    @Override
    public void startDocument() throws SAXException {
        this.getBackingHandler().startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.getBackingHandler().endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.getBackingHandler().startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.getBackingHandler().endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.getBackingHandler().startElement(uri, localName, qName, atts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.getBackingHandler().endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.getBackingHandler().characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.getBackingHandler().ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.getBackingHandler().processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.getBackingHandler().skippedEntity(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ForwardingTaskList
    extends AbstractList<ITaggedBlockTaskHandler> {
        protected List<ITaggedBlockTaskHandler> internalList = new LinkedList<ITaggedBlockTaskHandler>();

        protected ForwardingTaskList() {
        }

        protected List<ITaggedBlockTaskHandler> getBackingList() {
            return LazyForwardingHandler.this.backingHandler == null ? this.internalList : LazyForwardingHandler.this.backingHandler.getTaggedBlockTasks();
        }

        protected List<ITaggedBlockTaskHandler> getInternalList() {
            return this.internalList;
        }

        @Override
        public ITaggedBlockTaskHandler get(int index) {
            return this.getBackingList().get(index);
        }

        @Override
        public int size() {
            return this.getBackingList().size();
        }

        @Override
        public ITaggedBlockTaskHandler set(int index, ITaggedBlockTaskHandler element) {
            return this.getBackingList().set(index, element);
        }

        @Override
        public void add(int index, ITaggedBlockTaskHandler element) {
            this.getBackingList().add(index, element);
        }

        @Override
        public ITaggedBlockTaskHandler remove(int index) {
            return this.getBackingList().remove(index);
        }
    }
}

