/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.util.parse;

import edu.mit.jverbnet.util.Checks;
import edu.mit.jverbnet.util.parse.IHasParserHandler;
import edu.mit.jverbnet.util.parse.ITaggedHandler;
import edu.mit.jverbnet.util.parse.MappedHandler;
import edu.mit.jverbnet.util.parse.TaggedBlockTaskHandlerAdapter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListHandler<T>
extends MappedHandler<List<T>> {
    private final ITaggedHandler<? extends T> listElementHandler;
    private List<T> elements = new LinkedList<T>();
    private boolean allowNullElements = false;

    public ListHandler(String tag, ITaggedHandler<? extends T> elementHandler) {
        this(null, null, tag, elementHandler);
    }

    public ListHandler(XMLReader parser, String tag, ITaggedHandler<? extends T> elementHandler) {
        this(parser, null, tag, elementHandler);
    }

    public ListHandler(IHasParserHandler parent, String tag, ITaggedHandler<? extends T> elementHandler) {
        this(parent.getParser(), parent, tag, elementHandler);
    }

    public ListHandler(XMLReader parser, ContentHandler parent, String tag, ITaggedHandler<? extends T> elementHandler) {
        super(parser, parent, tag);
        Checks.NotNull.check("elementHandler", elementHandler);
        elementHandler.setParent(this);
        elementHandler.getTaggedBlockTasks().add(new TaggedBlockTaskHandlerAdapter(){

            public void endTaggedBlock(String uri, String localName, String qName) throws SAXException {
                Object elem = ListHandler.this.listElementHandler.getElement();
                if (elem == null && !ListHandler.this.allowNullElements) {
                    throw new NullPointerException("elements may not be null");
                }
                ListHandler.this.elements.add(elem);
            }
        });
        this.listElementHandler = elementHandler;
    }

    @Override
    protected void initHandlerMap(Map<String, ContentHandler> map) {
        map.put(this.listElementHandler.getTag(), this.listElementHandler);
    }

    @Override
    public void clearLocal() {
        this.elements = new LinkedList<T>();
    }

    public void setAllowNullElements(boolean value) {
        this.allowNullElements = value;
    }

    public boolean allowsNullElements() {
        return this.allowNullElements;
    }

    @Override
    public List<T> doGetElement() {
        return this.elements;
    }
}

