/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.data;

import edu.mit.jverbnet.data.IThematicRole;
import edu.mit.jverbnet.data.IVerbClass;
import edu.mit.jverbnet.data.ThematicRoleType;
import edu.mit.jverbnet.data.selection.ISelRestrictions;
import edu.mit.jverbnet.data.selection.SelRestrictions;
import edu.mit.jverbnet.data.selection.SemRestrType;
import edu.mit.jverbnet.util.Checks;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThematicRole
implements IThematicRole {
    private final IVerbClass parent;
    private final ThematicRoleType type;
    private final ISelRestrictions<SemRestrType> selRestrs;

    public ThematicRole(IVerbClass parent, ThematicRoleType type, ISelRestrictions<SemRestrType> selRestrs) {
        Checks.NotNull.check("parent", parent);
        Checks.NotNull.check("type", type);
        if (selRestrs == null) {
            selRestrs = SelRestrictions.emptyRestrictions();
        }
        this.parent = parent;
        this.type = type;
        this.selRestrs = selRestrs;
    }

    @Override
    public IVerbClass getVerbClass() {
        return this.parent;
    }

    @Override
    public ThematicRoleType getType() {
        return this.type;
    }

    @Override
    public ISelRestrictions<SemRestrType> getSelRestrictions() {
        return this.selRestrs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ThematicRoleBuilder
    implements IThematicRole.IThematicRoleBuilder {
        private ThematicRoleType type;
        private ISelRestrictions<SemRestrType> selRestrs;

        @Override
        public IVerbClass getVerbClass() {
            return (IVerbClass)Checks.thisMethodShouldNeverBeCalled();
        }

        @Override
        public ThematicRoleType getType() {
            return this.type;
        }

        @Override
        public ISelRestrictions<SemRestrType> getSelRestrictions() {
            return this.selRestrs;
        }

        @Override
        public void setType(ThematicRoleType type) {
            this.type = type;
        }

        @Override
        public void setSelRestrictions(ISelRestrictions<SemRestrType> selRestrs) {
            this.selRestrs = selRestrs;
        }

        @Override
        public ThematicRole create(IVerbClass parent) {
            return new ThematicRole(parent, this.type, this.selRestrs);
        }
    }
}

