/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.data.semantics;

import edu.mit.jverbnet.data.IVerbnetType;
import edu.mit.jverbnet.data.ThematicRoleType;
import edu.mit.jverbnet.data.VerbnetTypes;
import edu.mit.jverbnet.data.semantics.ArgTypeConstant;
import edu.mit.jverbnet.data.semantics.ArgTypeEvent;
import edu.mit.jverbnet.data.semantics.ArgTypeVerbSpecific;
import edu.mit.jverbnet.data.semantics.ISemanticArgType;
import edu.mit.jverbnet.util.Checks;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ArgType implements IVerbnetType
{
    Constant("Constant", ArgTypeConstant.class),
    Event("Event", ArgTypeEvent.class),
    ThemRole("ThemRole", ThematicRoleType.class),
    VerbSpecific("VerbSpecific", ArgTypeVerbSpecific.class);

    public static final String XSD_TYPE_NAME = "argType";
    private final String id;
    private final Class<? extends ISemanticArgType> subclassType;
    private static Map<String, ArgType> idMap;

    private ArgType(String id, Class<? extends ISemanticArgType> subclassType) {
        id = Checks.NotNullEmptyOrBlank.check("id", id);
        Checks.NotNull.check("subclassType", subclassType);
        this.id = id;
        this.subclassType = subclassType;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public Class<? extends ISemanticArgType> getSubclassType() {
        return this.subclassType;
    }

    public static ArgType getById(String id) {
        Checks.NotNullEmptyOrBlank.check("id", id);
        ArgType result = idMap.get(id.toLowerCase());
        VerbnetTypes.printIdWarnings(ArgType.class, result, id);
        return result;
    }

    static {
        ArgType[] values = ArgType.values();
        idMap = new HashMap<String, ArgType>(values.length);
        for (ArgType t : values) {
            ArgType conflict = idMap.put(t.getID().toLowerCase(), t);
            if (conflict == null) continue;
            throw new IllegalStateException("The constants " + t.name() + " and " + conflict.name() + " of the enum " + ArgType.class.getSimpleName() + " have identical normalized ids: " + t.getID().toLowerCase());
        }
    }
}

