/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.parse;

import edu.mit.jverbnet.data.IWordnetKey;
import edu.mit.jverbnet.data.Member;
import edu.mit.jverbnet.data.WordnetKey;
import edu.mit.jverbnet.util.Checks;
import edu.mit.jverbnet.util.parse.IHasParserHandler;
import edu.mit.jverbnet.util.parse.MappedHandler;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberHandler
extends MappedHandler<Member.MemberBuilder> {
    public static final String XML_TAG_MEMBERS = "MEMBERS";
    public static final String XML_TAG_MEMBER = "MEMBER";
    private String name;
    private List<IWordnetKey> wnTypes;
    private List<String> groupings;
    private final Pattern listPattern = Pattern.compile("\\s+");

    public MemberHandler() {
        this((XMLReader)null, (ContentHandler)null);
    }

    public MemberHandler(IHasParserHandler parent) {
        this(parent == null ? null : parent.getParser(), parent);
    }

    public MemberHandler(XMLReader parser) {
        this(parser, (ContentHandler)null);
    }

    public MemberHandler(XMLReader parser, ContentHandler parent) {
        super(parser, parent, XML_TAG_MEMBER);
    }

    @Override
    protected void clearLocal() {
        this.name = null;
        this.wnTypes = new LinkedList<IWordnetKey>();
        this.groupings = new LinkedList<String>();
    }

    @Override
    public void startTaggedBlock(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        String[] gStrs;
        String[] wnStrs;
        this.name = attrs.getValue("name");
        String wnList = attrs.getValue("wn").trim();
        for (String wnStr : wnStrs = this.listPattern.split(wnList)) {
            if (wnStr.length() == 0) continue;
            WordnetKey wnKey = WordnetKey.parseKey(wnStr);
            this.wnTypes.add(wnKey);
        }
        String gList = Checks.trimAndMaskNull(attrs.getValue("grouping"), "");
        for (String gStr : gStrs = this.listPattern.split(gList)) {
            if (gStr.length() <= 0) continue;
            this.groupings.add(gStr);
        }
    }

    @Override
    public Member.MemberBuilder doGetElement() {
        Member.MemberBuilder result = new Member.MemberBuilder();
        result.setName(this.name);
        result.getWordnetTypes().addAll(this.wnTypes);
        result.getGroupings().addAll(this.groupings);
        return result;
    }
}

