/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.parse;

import edu.mit.jverbnet.data.IVerbnetType;
import edu.mit.jverbnet.data.selection.ISelRestrictions;
import edu.mit.jverbnet.data.selection.SelRestrictions;
import edu.mit.jverbnet.parse.RestrictionHandler;
import edu.mit.jverbnet.util.Checks;
import edu.mit.jverbnet.util.parse.IHasParserHandler;
import edu.mit.jverbnet.util.parse.ITaggedHandler;
import edu.mit.jverbnet.util.parse.LazyForwardingHandler;
import edu.mit.jverbnet.util.parse.MappedHandler;
import edu.mit.jverbnet.util.parse.TaggedBlockTaskHandlerAdapter;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelRestrictionsHandler<T extends IVerbnetType>
extends MappedHandler<ISelRestrictions<T>> {
    public static final String XML_TAG_SELRESTRS = "SELRESTRS";
    public static final String XML_TAG_SYNRESTRS = "SYNRESTRS";
    private final boolean isSelRestr;
    private final Class<T> verbnetTypeClass;
    private ISelRestrictions.Logic logic;
    private Map<T, Boolean> restrictionMap;
    private List<ISelRestrictions<T>> subRestrs;

    public SelRestrictionsHandler(boolean isSelRestr, Class<T> verbnetTypeClass) {
        this(null, null, isSelRestr, verbnetTypeClass);
    }

    public SelRestrictionsHandler(IHasParserHandler parent, boolean isSelRestr, Class<T> verbnetTypeClass) {
        this(parent == null ? null : parent.getParser(), parent, isSelRestr, verbnetTypeClass);
    }

    public SelRestrictionsHandler(XMLReader parser, boolean isSelRestr, Class<T> verbnetTypeClass) {
        this(parser, null, isSelRestr, verbnetTypeClass);
    }

    public SelRestrictionsHandler(XMLReader parser, ContentHandler parent, boolean isSelRestr, Class<T> verbnetTypeClass) {
        super(parser, parent, isSelRestr ? XML_TAG_SELRESTRS : XML_TAG_SYNRESTRS);
        Checks.NotNull.check("verbnetTypeClass", verbnetTypeClass);
        this.isSelRestr = isSelRestr;
        this.verbnetTypeClass = verbnetTypeClass;
    }

    @Override
    protected void initHandlerMap(Map<String, ContentHandler> map) {
        RestrictionHandler restrHandler = new RestrictionHandler<T>(this, this.isSelRestr, this.verbnetTypeClass){

            @Override
            public void endTaggedBlock(String uri, String localName, String qName) throws SAXException {
                Object e = this.doGetElement();
                SelRestrictionsHandler.this.restrictionMap.put(e.getKey(), e.getValue());
            }
        };
        final LazyForwardingHandler subRestrsHandler = new LazyForwardingHandler<ISelRestrictions<T>>(this, this.getTag()){

            @Override
            protected ITaggedHandler<ISelRestrictions<T>> createBackingHandler() {
                return new SelRestrictionsHandler(SelRestrictionsHandler.this.isSelRestr, SelRestrictionsHandler.this.verbnetTypeClass);
            }
        };
        subRestrsHandler.getTaggedBlockTasks().add(new TaggedBlockTaskHandlerAdapter(){

            public void endTaggedBlock(String uri, String localName, String qName) throws SAXException {
                SelRestrictionsHandler.this.subRestrs.add(subRestrsHandler.getElement());
            }
        });
        map.put(restrHandler.getTag(), restrHandler);
        map.put(subRestrsHandler.getTag(), subRestrsHandler);
    }

    @Override
    protected void clearLocal() {
        this.logic = null;
        this.restrictionMap = new LinkedHashMap<T, Boolean>();
        this.subRestrs = new LinkedList<ISelRestrictions<T>>();
    }

    @Override
    public void startTaggedBlock(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        String logicStr = attrs.getValue("logic");
        this.logic = Checks.IsNullEmptyOrBlank.is(logicStr) ? null : ISelRestrictions.Logic.valueOf(logicStr.toUpperCase());
    }

    @Override
    public ISelRestrictions<T> doGetElement() {
        if (this.restrictionMap.isEmpty() && this.subRestrs.isEmpty()) {
            return null;
        }
        return new SelRestrictions<T>(this.logic, this.restrictionMap, this.subRestrs);
    }
}

