/***************************************************************************
* JVerbnet v1.1.0
* Copyright (c) 2012 Massachusetts Institute of Technology
* 
* JVerbnet is distributed under the terms of the Creative Commons 
* Attribution 3.0 Unported License, which means it may be freely used for 
* all purposes, as long as proper acknowledgment is made.  See the license 
* file included with this distribution for more details.
****************************************************************************/

package edu.mit.jverbnet.data.syntax;

import edu.mit.jverbnet.data.selection.IRestrType;
import edu.mit.jverbnet.data.selection.ISelRestrictions;

/**
 * Description of a syntactic argument.
 * 
 * @author Mark A. Finlayson
 * @version 1.1.0
 * @since JVerbnet 1.0.0
 */
public interface ISyntaxArgDesc {

	/**
	 * Returns the type of the syntactic argument. Will never be
	 * <code>null</code>.
	 * 
	 * @return the non-<code>null</code> type of the syntactic argument
	 * @since JVerbnet 1.0.0
	 */
	public SyntaxArgType getType();

	/**
	 * Returns the value of the syntactic argument. May be <code>null</code>.
	 * 
	 * @return the possibly <code>null</code> value of the syntactic argument
	 * @since JVerbnet 1.0.0
	 */
	public String getValue();

	/**
	 * If the {@link #getType()} method returns {@link SyntaxArgType#NP}, this
	 * method will return a noun phrase type. Otherwise it will return
	 * <code>null</code>.
	 * 
	 * @return <code>null</code> if the type of the argument is not a noun
	 *         phrase; otherwise a noun phrase type
	 * @since JVerbnet 1.0.0
	 */
	public INounPhraseType getNounPhraseType();

	/**
	 * Returns the selectional restrictions for this argument. Will never return
	 * <code>null</code>.
	 * 
	 * @return the selection restrictions for this argument
	 * @since JVerbnet 1.0.0
	 */
	public ISelRestrictions<? extends IRestrType> getSelRestrictions();

}
