/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.data;

import edu.mit.jverbnet.data.IMember;
import edu.mit.jverbnet.data.IVerbClass;
import edu.mit.jverbnet.data.IWordnetKey;
import edu.mit.jverbnet.util.Checks;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Member
implements IMember {
    private final IVerbClass verbCls;
    private final String name;
    private final Map<IWordnetKey, Boolean> keys;
    private final List<String> groupings;

    public Member(IVerbClass verbCls, String name, Map<IWordnetKey, Boolean> keys, List<String> groupings) {
        Checks.NotNull.check("verbCls", verbCls);
        name = Checks.NotNullEmptyOrBlank.check("name", name);
        keys = Checks.allKeysAndValuesAre(Checks.NotNull, "keys", keys, Checks.UnmodifiableMaskNullWithEmpty);
        groupings = Checks.allElementsAre(Checks.NotNullEmptyOrBlank, "groupings", groupings, Checks.UnmodifiableMaskNullWithEmpty);
        this.verbCls = verbCls;
        this.name = name;
        this.keys = keys;
        this.groupings = groupings;
    }

    @Override
    public IVerbClass getVerbClass() {
        return this.verbCls;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<IWordnetKey, Boolean> getWordnetTypes() {
        return this.keys;
    }

    @Override
    public List<String> getGroupings() {
        return this.groupings;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemberBuilder
    implements IMember.IMemberBuilder {
        private String name;
        private Map<IWordnetKey, Boolean> keys = new LinkedHashMap<IWordnetKey, Boolean>();
        private List<String> groupings = new LinkedList<String>();

        @Override
        public IVerbClass getVerbClass() {
            return (IVerbClass)Checks.thisMethodShouldNeverBeCalled();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public Map<IWordnetKey, Boolean> getWordnetTypes() {
            return this.keys;
        }

        @Override
        public List<String> getGroupings() {
            return this.groupings;
        }

        @Override
        public IMember create(IVerbClass parent) {
            return new Member(parent, this.name, this.keys, this.groupings);
        }
    }
}

