/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.data.syntax;

import edu.mit.jverbnet.data.IVerbnetType;
import edu.mit.jverbnet.data.VerbnetTypes;
import edu.mit.jverbnet.data.syntax.AuxNounPhraseType;
import edu.mit.jverbnet.util.Checks;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SyntaxArgType implements IVerbnetType
{
    NP("NP", "Noun Phrase", VALUE_RULE.REQUIRED),
    ADV("ADV", "Adverb", VALUE_RULE.PROHIBITED),
    ADJ("ADJ", "Adjective", VALUE_RULE.PROHIBITED),
    PREP("PREP", "Preposition", VALUE_RULE.OPTIONAL),
    LEX("LEX", "Lexical", VALUE_RULE.REQUIRED);

    public static final String XSD_TYPE_NAME = "argType";
    private final String id;
    private final String name;
    private final VALUE_RULE vRule;
    private static Map<String, SyntaxArgType> idMap;

    private SyntaxArgType(String id, String name, VALUE_RULE vRule) {
        id = Checks.NotNullEmptyOrBlank.check("id", id);
        name = Checks.NotNullEmptyOrBlank.check("name", name);
        Checks.NotNull.check("vRule", vRule);
        this.id = id;
        this.name = name;
        this.vRule = vRule;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public VALUE_RULE getValueRule() {
        return this.vRule;
    }

    public static SyntaxArgType getById(String id) {
        Checks.NotNullEmptyOrBlank.check("id", id);
        SyntaxArgType result = idMap.get(id.toLowerCase());
        VerbnetTypes.printIdWarnings(AuxNounPhraseType.class, result, id);
        return result;
    }

    static {
        SyntaxArgType[] values = SyntaxArgType.values();
        idMap = new HashMap<String, SyntaxArgType>(values.length);
        for (SyntaxArgType t : values) {
            SyntaxArgType conflict = idMap.put(t.getID().toLowerCase(), t);
            if (conflict == null) continue;
            throw new IllegalStateException("The constants " + t.name() + " and " + conflict.name() + " of the enum " + SyntaxArgType.class.getSimpleName() + " have identical normalized ids: " + t.getID().toLowerCase());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VALUE_RULE {
        PROHIBITED{

            public String checkValue(String value) {
                Checks.IsNull.check("value", value);
                return null;
            }
        }
        ,
        OPTIONAL{

            public String checkValue(String value) {
                return Checks.trim(Checks.NotNull, value);
            }
        }
        ,
        REQUIRED{

            public String checkValue(String value) {
                return Checks.NotNullEmptyOrBlank.check("value", value);
            }
        };


        public abstract String checkValue(String var1);
    }
}

