/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.util;

import edu.mit.jverbnet.util.Checks;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class ByteBufferInputStream
extends InputStream {
    protected ByteBuffer buffer;
    protected RandomAccessFile raFile;
    protected int mark = -1;

    public ByteBufferInputStream(ByteBuffer buffer) {
        Checks.NotNull.check("buffer", buffer);
        this.buffer = buffer;
    }

    public ByteBufferInputStream(File file) throws IOException {
        this.raFile = new RandomAccessFile(file, "r");
        FileChannel channel = this.raFile.getChannel();
        this.buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
    }

    protected void checkBuffer() throws IOException {
        if (this.buffer == null) {
            throw new IOException("Stream has been closed");
        }
    }

    public int read() throws IOException {
        this.checkBuffer();
        return this.buffer.get();
    }

    public int read(byte[] b) throws IOException {
        this.checkBuffer();
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.checkBuffer();
        Checks.NotNull.check("b", b);
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        len = Math.min(this.buffer.remaining(), len);
        if (len == 0) {
            return -1;
        }
        this.buffer.get(b, off, len);
        return len;
    }

    public long skip(long n) throws IOException {
        this.checkBuffer();
        if (n <= 0L) {
            return 0L;
        }
        int skip = Math.min(this.buffer.remaining(), (int)n);
        this.buffer.position(this.buffer.position() + skip);
        return skip;
    }

    public int available() throws IOException {
        this.checkBuffer();
        return this.buffer.remaining();
    }

    public void close() throws IOException {
        this.buffer = null;
        if (this.raFile != null) {
            this.raFile.close();
        }
    }

    public synchronized void mark(int readlimit) {
        this.mark = this.buffer.position();
    }

    public synchronized void reset() throws IOException {
        if (this.mark == -1) {
            throw new IOException("mark not set");
        }
        this.buffer.position(this.mark);
    }

    public boolean markSupported() {
        return true;
    }
}

