/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.util;

import edu.mit.jverbnet.util.Checks;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;

public class ResourceUtils {
    public static File toFileChecked(URL url) throws IOException {
        Checks.NotNull.check("url", url);
        if (url.getProtocol().equals("file")) {
            return ResourceUtils.toFile(url);
        }
        return null;
    }

    public static File toFile(URL url) throws IOException {
        Checks.NotNull.check("url", url);
        if (!url.getProtocol().equals("file")) {
            throw new IllegalArgumentException("URL source must use 'file' protocol");
        }
        return new File(URLDecoder.decode(url.getPath(), "UTF-8"));
    }

    public static URL toURL(File file) {
        Checks.NotNull.check("file", file);
        try {
            URI uri = new URI("file", "//", file.toURL().getPath(), null);
            return new URL("file", null, uri.getRawPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }
}

