/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.data;

import edu.mit.jverbnet.data.FrameType;
import edu.mit.jverbnet.data.IFrame;
import edu.mit.jverbnet.data.IVerbClass;
import edu.mit.jverbnet.data.semantics.ISemanticDesc;
import edu.mit.jverbnet.data.syntax.ISyntaxDesc;
import edu.mit.jverbnet.data.syntax.SyntaxDesc;
import edu.mit.jverbnet.util.Checks;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frame
implements IFrame {
    private final IVerbClass parent;
    private final String descNum;
    private final FrameType firstType;
    private final FrameType secondType;
    private final String xTag;
    private final List<String> examples;
    private final ISyntaxDesc syntaxDesc;
    private final ISemanticDesc semDesc;

    public Frame(IVerbClass parent, String descNum, FrameType firstType, FrameType secondType, String xTag, List<String> examples, ISyntaxDesc syntaxDesc, ISemanticDesc semDesc) {
        Checks.NotNull.check("parent", parent);
        descNum = Checks.trimAndMask(Checks.NotNull, descNum, Checks.IsNullOrEmpty, null);
        Checks.NotNull.check("firstType", firstType);
        xTag = Checks.trimAndMask(Checks.NotNull, xTag, Checks.IsNullOrEmpty, null);
        examples = Checks.allElementsAre(Checks.NotNullEmptyOrBlank, "examples", examples, Checks.UnmodifiableMaskNullWithEmpty);
        syntaxDesc = Checks.IsNull.mask(syntaxDesc, SyntaxDesc.EMPTY_SYNTAX);
        Checks.NotNull.check("semDesc", semDesc);
        this.parent = parent;
        this.descNum = descNum;
        this.firstType = firstType;
        this.secondType = secondType;
        this.xTag = xTag;
        this.examples = examples;
        this.syntaxDesc = syntaxDesc;
        this.semDesc = semDesc;
    }

    @Override
    public IVerbClass getVerbClass() {
        return this.parent;
    }

    @Override
    public String getDescriptionNumber() {
        return this.descNum;
    }

    @Override
    public FrameType getPrimaryType() {
        return this.firstType;
    }

    @Override
    public FrameType getSecondaryType() {
        return this.secondType;
    }

    @Override
    public String getXTag() {
        return this.xTag;
    }

    @Override
    public List<String> getExamples() {
        return this.examples;
    }

    @Override
    public ISyntaxDesc getSyntax() {
        return this.syntaxDesc;
    }

    @Override
    public ISemanticDesc getSemantics() {
        return this.semDesc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FrameBuilder
    implements IFrame.IFrameBuilder {
        private String descNum;
        private FrameType primaryType;
        private FrameType secondaryType;
        private String xTag;
        private ISyntaxDesc syntaxD;
        private ISemanticDesc semanticD;
        private List<String> examples = new LinkedList<String>();

        @Override
        public IVerbClass getVerbClass() {
            return (IVerbClass)Checks.thisMethodShouldNeverBeCalled();
        }

        @Override
        public String getDescriptionNumber() {
            return this.descNum;
        }

        @Override
        public FrameType getPrimaryType() {
            return this.primaryType;
        }

        @Override
        public FrameType getSecondaryType() {
            return this.secondaryType;
        }

        @Override
        public String getXTag() {
            return this.xTag;
        }

        @Override
        public List<String> getExamples() {
            return this.examples;
        }

        @Override
        public ISyntaxDesc getSyntax() {
            return this.syntaxD;
        }

        @Override
        public ISemanticDesc getSemantics() {
            return this.semanticD;
        }

        @Override
        public void setDescriptionNumber(String descNum) {
            this.descNum = descNum;
        }

        @Override
        public void setPrimaryType(FrameType type) {
            this.primaryType = type;
        }

        @Override
        public void setSecondaryType(FrameType type) {
            this.secondaryType = type;
        }

        @Override
        public void setXTag(String xTag) {
            this.xTag = xTag;
        }

        @Override
        public void setSyntax(ISyntaxDesc syntax) {
            this.syntaxD = syntax;
        }

        @Override
        public void setSemantics(ISemanticDesc semantics) {
            this.semanticD = semantics;
        }

        @Override
        public Frame create(IVerbClass parent) {
            return new Frame(parent, this.descNum, this.primaryType, this.secondaryType, this.xTag, this.examples, this.syntaxD, this.semanticD);
        }
    }
}

