/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.data;

import edu.mit.jverbnet.data.IVerbnetType;
import edu.mit.jverbnet.data.ThematicRoleType;
import edu.mit.jverbnet.data.syntax.AuxNounPhraseType;
import edu.mit.jverbnet.data.syntax.INounPhraseType;
import edu.mit.jverbnet.util.IHasID;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerbnetTypes {
    public static final String plus = "+";
    public static final String minus = "-";
    private static boolean isPrintingIdWarnings = false;

    public static <T extends IVerbnetType> T getById(Class<T> cls, String id) {
        T result = VerbnetTypes.getTypeByIdNoWarnings(cls, id);
        VerbnetTypes.printIdWarnings(cls, result, id);
        return result;
    }

    public static <T extends IVerbnetType> T getTypeByIdNoWarnings(Class<T> cls, String id) {
        try {
            Method method = cls.getMethod("getById", String.class);
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new IllegalStateException("getById method on " + cls.getName() + " is not static");
            }
            return (T)((IVerbnetType)method.invoke(null, id));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static String getXSDSimpleTypeName(Class<? extends IVerbnetType> c) {
        Field field = null;
        try {
            field = c.getField("XSD_TYPE_NAME");
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        try {
            return (String)field.get(null);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean getSelectionRestriction(String value) {
        if (value == null) {
            return true;
        }
        if (plus.equals(value)) {
            return true;
        }
        if (minus.equals(value)) {
            return false;
        }
        throw new IllegalArgumentException("Illegal selection restriction value: " + value);
    }

    public static INounPhraseType getNounPhraseTypeById(String id) {
        AuxNounPhraseType result = AuxNounPhraseType.getById(id);
        if (result != null) {
            return result;
        }
        return ThematicRoleType.getById(id);
    }

    public static boolean isPrintingIdWarnings() {
        return isPrintingIdWarnings;
    }

    public static void setPrintIdWarnings(boolean value) {
        isPrintingIdWarnings = value;
    }

    public static void printIdWarnings(Class<? extends IHasID> cls, IHasID type, String id) {
        if (type == null) {
            VerbnetTypes.printIdUnknownWarning(cls, id);
        } else if (!id.equals(type.getID())) {
            VerbnetTypes.printIdNormalizationWarning(cls, id);
        }
    }

    public static void printIdUnknownWarning(Class<? extends IHasID> cls, String id) {
        if (isPrintingIdWarnings) {
            System.err.println("Unknown id '" + id + "' for type " + cls.getSimpleName());
        }
    }

    public static void printIdNormalizationWarning(Class<? extends IHasID> type, String id) {
        if (isPrintingIdWarnings) {
            System.err.println("Normalization of id '" + id + "' was required to retrieve the value for type " + type.getSimpleName());
        }
    }
}

