/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.data.semantics;

import edu.mit.jverbnet.data.VerbnetTypes;
import edu.mit.jverbnet.data.semantics.ArgType;
import edu.mit.jverbnet.data.semantics.ISemanticArgType;
import edu.mit.jverbnet.util.Checks;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ArgTypeEvent implements ISemanticArgType
{
    E("E"),
    E0("E0"),
    E1("E1"),
    duringE("during(E)"),
    duringE0("during(E0)"),
    duringE1("during(E1)"),
    endE("end(E)"),
    endE0("end(E0)"),
    endE1("end(E1)"),
    resultE("result(E)"),
    resultE0("result(E0)"),
    resultE1("result(E1)"),
    startE("start(E)"),
    startE0("start(E0)"),
    startE1("start(E1)");

    public static final String XSD_TYPE_NAME = "argEventType";
    private final String id;
    private static Map<String, ArgTypeEvent> idMap;

    private ArgTypeEvent(String id) {
        this.id = Checks.NotNullEmptyOrBlank.check("id", id);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public ArgType getArgType() {
        return ArgType.Event;
    }

    public static ArgTypeEvent getById(String id) {
        Checks.NotNullEmptyOrBlank.check("id", id);
        ArgTypeEvent result = idMap.get(id.toLowerCase());
        VerbnetTypes.printIdWarnings(ArgTypeEvent.class, result, id);
        return result;
    }

    public String toString() {
        return this.getID();
    }

    static {
        ArgTypeEvent[] values = ArgTypeEvent.values();
        idMap = new HashMap<String, ArgTypeEvent>(values.length);
        for (ArgTypeEvent t : values) {
            ArgTypeEvent conflict = idMap.put(t.getID().toLowerCase(), t);
            if (conflict == null) continue;
            throw new IllegalStateException("The constants " + t.name() + " and " + conflict.name() + " of the enum " + ArgTypeEvent.class.getSimpleName() + " have identical normalized ids: " + t.getID().toLowerCase());
        }
    }
}

