/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.data.syntax;

import edu.mit.jverbnet.data.selection.IRestrType;
import edu.mit.jverbnet.data.selection.ISelRestrictions;
import edu.mit.jverbnet.data.selection.SelRestrictions;
import edu.mit.jverbnet.data.syntax.INounPhraseType;
import edu.mit.jverbnet.data.syntax.ISyntaxArgDesc;
import edu.mit.jverbnet.data.syntax.ISyntaxDesc;
import edu.mit.jverbnet.data.syntax.SyntaxArgType;
import edu.mit.jverbnet.util.Checks;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxArgDesc
implements ISyntaxArgDesc {
    private final ISyntaxDesc parent;
    private final SyntaxArgType type;
    private final String value;
    private final INounPhraseType npType;
    private final ISelRestrictions<? extends IRestrType> selRestrs;

    public SyntaxArgDesc(ISyntaxDesc parent, SyntaxArgType type, String value, ISelRestrictions<? extends IRestrType> selRestrs) {
        this(parent, type, value, null, selRestrs);
    }

    public SyntaxArgDesc(ISyntaxDesc parent, INounPhraseType type, String value, ISelRestrictions<? extends IRestrType> selRestrs) {
        this(parent, SyntaxArgType.NP, value, type, selRestrs);
    }

    public SyntaxArgDesc(ISyntaxDesc parent, SyntaxArgType type, String value, INounPhraseType npType, ISelRestrictions<? extends IRestrType> selRestrs) {
        Checks.NotNull.check("parent", parent);
        Checks.NotNull.check("type", type);
        value = type.getValueRule().checkValue(value);
        if (selRestrs == null) {
            selRestrs = SelRestrictions.emptyRestrictions();
        }
        if (type == SyntaxArgType.NP && npType == null) {
            throw new IllegalArgumentException("Must specific npType if argument type is NP");
        }
        if (type != SyntaxArgType.NP && npType != null) {
            throw new IllegalArgumentException("May not specific npType if argument type is not NP");
        }
        this.parent = parent;
        this.type = type;
        this.value = value;
        this.npType = npType;
        this.selRestrs = selRestrs;
    }

    @Override
    public ISyntaxDesc getParent() {
        return this.parent;
    }

    @Override
    public SyntaxArgType getType() {
        return this.type;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public INounPhraseType getNounPhraseType() {
        return this.npType;
    }

    @Override
    public ISelRestrictions<? extends IRestrType> getSelRestrictions() {
        return this.selRestrs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SyntaxArgDescBuilder
    implements ISyntaxArgDesc.ISyntaxArgDescBuilder {
        private SyntaxArgType type;
        private String value;
        private INounPhraseType npType;
        private ISelRestrictions<? extends IRestrType> selRestrs;

        public SyntaxArgDescBuilder(SyntaxArgType type, String value, INounPhraseType npType, ISelRestrictions<? extends IRestrType> selRestrs) {
            this.type = type;
            this.value = value;
            this.npType = npType;
            this.selRestrs = selRestrs;
        }

        @Override
        public ISyntaxDesc getParent() {
            return (ISyntaxDesc)Checks.thisMethodShouldNeverBeCalled();
        }

        @Override
        public SyntaxArgType getType() {
            return this.type;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public INounPhraseType getNounPhraseType() {
            return this.npType;
        }

        @Override
        public ISelRestrictions<? extends IRestrType> getSelRestrictions() {
            return this.selRestrs;
        }

        @Override
        public void setType(SyntaxArgType type) {
            this.type = type;
            if (type != SyntaxArgType.NP) {
                this.npType = null;
            }
        }

        @Override
        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public void setNounPhrasetype(INounPhraseType npType) {
            if (npType == null) {
                return;
            }
            this.type = SyntaxArgType.NP;
            this.npType = npType;
        }

        @Override
        public void setSelRestrictions(ISelRestrictions<? extends IRestrType> restrs) {
            this.selRestrs = restrs;
        }

        @Override
        public ISyntaxArgDesc create(ISyntaxDesc parent) {
            return new SyntaxArgDesc(parent, this.type, this.value, this.npType, this.selRestrs);
        }
    }
}

