/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.parse;

import edu.mit.jverbnet.data.Frame;
import edu.mit.jverbnet.data.FrameType;
import edu.mit.jverbnet.data.semantics.ISemanticDesc;
import edu.mit.jverbnet.data.syntax.ISyntaxDesc;
import edu.mit.jverbnet.parse.SemanticDescHandler;
import edu.mit.jverbnet.parse.SyntaxDescHandler;
import edu.mit.jverbnet.util.parse.CDataHandler;
import edu.mit.jverbnet.util.parse.IHasParserHandler;
import edu.mit.jverbnet.util.parse.ListHandler;
import edu.mit.jverbnet.util.parse.MappedHandler;
import java.util.Collection;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameHandler
extends MappedHandler<Frame.FrameBuilder> {
    public static final String XML_TAG_FRAMES = "FRAMES";
    public static final String XML_TAG_FRAME = "FRAME";
    public static final String XML_TAG_DESCRIPTION = "DESCRIPTION";
    public static final String XML_TAG_EXAMPLES = "EXAMPLES";
    public static final String XML_TAG_EXAMPLE = "EXAMPLE";
    private final ListHandler<String> examplesHandler = new ListHandler<String>(this, "EXAMPLES", new CDataHandler("EXAMPLE"));
    private String descNum;
    private FrameType primaryType;
    private FrameType secondaryType;
    private String xTag;
    private ISyntaxDesc syntaxDesc;
    private ISemanticDesc semanticDesc;

    public FrameHandler() {
        this((XMLReader)null, (ContentHandler)null);
    }

    public FrameHandler(IHasParserHandler parent) {
        this(parent == null ? null : parent.getParser(), parent);
    }

    public FrameHandler(XMLReader parser) {
        this(parser, (ContentHandler)null);
    }

    public FrameHandler(XMLReader parser, ContentHandler parent) {
        super(parser, parent, XML_TAG_FRAME);
    }

    @Override
    protected void initHandlerMap(Map<String, ContentHandler> map) {
        MappedHandler<Object> descHandler = new MappedHandler<Object>((IHasParserHandler)this, XML_TAG_DESCRIPTION){

            @Override
            public void startTaggedBlock(String uri, String localName, String qName, Attributes attrs) throws SAXException {
                FrameHandler.this.descNum = attrs.getValue("descriptionNumber");
                String primaryTypeStr = attrs.getValue("primary");
                String secondaryTypeStr = attrs.getValue("secondary");
                FrameHandler.this.xTag = attrs.getValue("xtag");
                FrameHandler.this.primaryType = FrameType.getById(primaryTypeStr);
                if (secondaryTypeStr.length() != 0) {
                    FrameHandler.this.secondaryType = FrameType.getById(secondaryTypeStr);
                }
            }
        };
        SyntaxDescHandler syntaxHandler = new SyntaxDescHandler(this){

            public void endTaggedBlock(String uri, String localName, String qName) throws SAXException {
                FrameHandler.this.syntaxDesc = this.doGetElement();
            }
        };
        SemanticDescHandler semanticsHandler = new SemanticDescHandler(this){

            public void endTaggedBlock(String uri, String localName, String qName) throws SAXException {
                FrameHandler.this.semanticDesc = this.doGetElement();
            }
        };
        map.put(descHandler.getTag(), descHandler);
        map.put(this.examplesHandler.getTag(), this.examplesHandler);
        map.put(syntaxHandler.getTag(), syntaxHandler);
        map.put(semanticsHandler.getTag(), semanticsHandler);
    }

    @Override
    protected void clearLocal() {
        this.descNum = null;
        this.primaryType = null;
        this.secondaryType = null;
        this.xTag = null;
        this.syntaxDesc = null;
        this.semanticDesc = null;
    }

    @Override
    public Frame.FrameBuilder doGetElement() {
        Frame.FrameBuilder result = new Frame.FrameBuilder();
        result.setDescriptionNumber(this.descNum);
        result.setPrimaryType(this.primaryType);
        result.setSecondaryType(this.secondaryType);
        result.setXTag(this.xTag);
        result.getExamples().addAll((Collection<String>)this.examplesHandler.doGetElement());
        result.setSyntax(this.syntaxDesc);
        result.setSemantics(this.semanticDesc);
        return result;
    }
}

