/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.parse;

import edu.mit.jverbnet.data.IVerbnetType;
import edu.mit.jverbnet.data.VerbnetTypes;
import edu.mit.jverbnet.util.Checks;
import edu.mit.jverbnet.util.parse.IHasParserHandler;
import edu.mit.jverbnet.util.parse.MappedHandler;
import java.util.Collections;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestrictionHandler<T extends IVerbnetType>
extends MappedHandler<Map.Entry<T, Boolean>> {
    public static final String XML_TAG_SELRESTR = "SELRESTR";
    public static final String XML_TAG_SYNRESTR = "SYNRESTR";
    private final Class<T> verbnetTypeClass;
    private T type;
    private Boolean value;

    public RestrictionHandler(boolean isSelRestr, Class<T> verbnetTypeClass) {
        this(null, null, isSelRestr, verbnetTypeClass);
    }

    public RestrictionHandler(IHasParserHandler parent, boolean isSelRestr, Class<T> verbnetTypeClass) {
        this(parent == null ? null : parent.getParser(), parent, isSelRestr, verbnetTypeClass);
    }

    public RestrictionHandler(XMLReader parser, boolean isSelRestr, Class<T> verbnetTypeClass) {
        this(parser, null, isSelRestr, verbnetTypeClass);
    }

    public RestrictionHandler(XMLReader parser, ContentHandler parent, boolean isSelRestr, Class<T> verbnetTypeClass) {
        super(parser, parent, isSelRestr ? XML_TAG_SELRESTR : XML_TAG_SYNRESTR);
        Checks.NotNull.check("verbnetTypeClass", verbnetTypeClass);
        this.verbnetTypeClass = verbnetTypeClass;
    }

    @Override
    protected void clearLocal() {
        this.type = null;
        this.value = null;
    }

    @Override
    public void startTaggedBlock(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        String typeStr = attrs.getValue("type");
        this.type = VerbnetTypes.getById(this.verbnetTypeClass, typeStr);
        this.value = VerbnetTypes.getSelectionRestriction(attrs.getValue("Value"));
        if (this.type == null) {
            throw new NullPointerException("Unknown value '" + typeStr + "' for type " + this.verbnetTypeClass.getSimpleName());
        }
        Checks.NotNull.check("value", this.value);
    }

    @Override
    public Map.Entry<T, Boolean> doGetElement() {
        return Collections.singletonMap(this.type, this.value).entrySet().iterator().next();
    }
}

