/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jverbnet.util.parse;

import edu.mit.jverbnet.util.Checks;
import edu.mit.jverbnet.util.parse.IHasParserHandler;
import edu.mit.jverbnet.util.parse.ITaggedBlockTaskHandler;
import edu.mit.jverbnet.util.parse.ITaggedHandler;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedHandler<T>
extends DefaultHandler
implements ITaggedHandler<T>,
ITaggedBlockTaskHandler {
    public static final String messageParserNotSet = "The parser for this handler is not set";
    public static final String messageIgnoringElementBlockExternal = "Ignoring element outside of TAG tagged block: ";
    public static final String messageUnmappedElementBlockInternal = "Found unmapped element inside TAG tagged block: ";
    protected static final Matcher messageMatcherIgnoreExternal = Pattern.compile("TAG").matcher("Ignoring element outside of TAG tagged block: ");
    protected static final Matcher messageMatcherIgnoreInternal = Pattern.compile("TAG").matcher("Found unmapped element inside TAG tagged block: ");
    private final String tag;
    private final List<ITaggedBlockTaskHandler> taggedBlockTasks = new LinkedList<ITaggedBlockTaskHandler>();
    private XMLReader parser = null;
    private ContentHandler parent = null;
    private IHasParserHandler parentHasP = null;
    private Map<String, ContentHandler> elementMap = null;
    private boolean reportWarnings = true;
    private Locator locator;
    protected Stack<String> tagStack = new Stack();

    public MappedHandler(String tag) {
        this(null, null, tag);
    }

    public MappedHandler(XMLReader parser, String tag) {
        this(parser, null, tag);
    }

    public MappedHandler(IHasParserHandler parent, String tag) {
        this(parent == null ? null : parent.getParser(), parent, tag);
    }

    public MappedHandler(XMLReader parser, ContentHandler parent, String tag) {
        tag = Checks.NotNullEmptyOrBlank.check("tag", tag);
        this.parent = parent;
        if (parent instanceof IHasParserHandler) {
            this.parentHasP = (IHasParserHandler)parent;
        }
        this.parser = parser;
        this.tag = tag;
    }

    @Override
    public XMLReader getParser() {
        return this.parentHasP != null ? this.parentHasP.getParser() : this.parser;
    }

    @Override
    public void setParser(XMLReader parser) {
        this.parser = parser;
    }

    @Override
    public ContentHandler getParent() {
        return this.parent;
    }

    protected void checkParserSet() {
        if (this.getParser() == null) {
            throw new IllegalStateException(messageParserNotSet);
        }
    }

    @Override
    public void setParent(ContentHandler parent) {
        this.parent = parent;
        this.parentHasP = parent instanceof IHasParserHandler ? (IHasParserHandler)parent : null;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    public boolean reportWarnings() {
        return this.reportWarnings;
    }

    public void setReportWarnings(boolean value) {
        this.reportWarnings = value;
        for (ContentHandler h : this.getHandlerMappings().values()) {
            if (!(h instanceof MappedHandler)) continue;
            ((MappedHandler)h).setReportWarnings(value);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    @Override
    public List<ITaggedBlockTaskHandler> getTaggedBlockTasks() {
        return this.taggedBlockTasks;
    }

    public final Map<String, ContentHandler> getHandlerMappings() {
        if (this.elementMap == null) {
            Map<String, ContentHandler> map = new HashMap<String, ContentHandler>();
            this.initHandlerMap(map);
            if (map.isEmpty()) {
                map = Collections.emptyMap();
            } else if (map.size() == 1) {
                Map.Entry<String, ContentHandler> e = map.entrySet().iterator().next();
                map = Collections.singletonMap(e.getKey(), e.getValue());
            } else {
                map = Collections.unmodifiableMap(new HashMap<String, ContentHandler>(map));
            }
            this.elementMap = map;
        }
        return this.elementMap;
    }

    protected void initHandlerMap(Map<String, ContentHandler> map) {
    }

    @Override
    public final void clear() {
        this.tagStack.clear();
        this.clearLocal();
        for (ContentHandler h : this.getHandlerMappings().values()) {
            if (!(h instanceof ITaggedHandler)) continue;
            ((ITaggedHandler)h).clear();
        }
    }

    protected void clearLocal() {
    }

    public boolean isInsideTaggedBlock() {
        return !this.tagStack.isEmpty();
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        this.checkParserSet();
        if (!this.isInsideTaggedBlock()) {
            if (this.getTag().equals(qName)) {
                this.tagStack.push(qName);
                this.getParser().setContentHandler(this);
                this.startTaggedBlock(uri, localName, qName, attrs);
                for (ITaggedBlockTaskHandler h : this.taggedBlockTasks) {
                    h.startTaggedBlock(uri, localName, qName, attrs);
                }
                return;
            }
            this.reportWarning(messageMatcherIgnoreExternal.replaceAll(this.getTag()) + qName);
        } else {
            ContentHandler child = this.getHandlerMappings().get(qName);
            if (child != null) {
                if (child instanceof ITaggedHandler) {
                    ((ITaggedHandler)child).clear();
                }
                child.startElement(uri, localName, qName, attrs);
            } else {
                this.tagStack.push(qName);
                this.reportWarning(messageMatcherIgnoreInternal.replaceAll(this.getTag()) + qName);
                this.handleUnmappedStartElement(uri, localName, qName, attrs);
            }
        }
    }

    @Override
    public void startTaggedBlock(String uri, String localName, String qName, Attributes attrs) throws SAXException {
    }

    protected void handleUnmappedStartElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
    }

    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
        this.checkParserSet();
        if (this.isInsideTaggedBlock()) {
            if (this.tagStack.peek().equals(qName)) {
                this.tagStack.pop();
                if (this.tagStack.isEmpty()) {
                    if (this.getParent() != null) {
                        this.getParser().setContentHandler(this.getParent());
                    }
                    this.endTaggedBlock(uri, localName, qName);
                    for (ITaggedBlockTaskHandler h : this.getTaggedBlockTasks()) {
                        h.endTaggedBlock(uri, localName, qName);
                    }
                } else {
                    this.handleUnmappedEndElement(uri, localName, qName);
                }
            } else {
                throw new SAXException("Unmatched end tag: " + qName);
            }
        }
    }

    @Override
    public void endTaggedBlock(String uri, String localName, String qName) throws SAXException {
    }

    protected void handleUnmappedEndElement(String uri, String localName, String qName) throws SAXException {
    }

    protected void reportWarning(String message) {
        ErrorHandler errorHandler;
        if (!this.reportWarnings) {
            return;
        }
        SAXParseException e = new SAXParseException(message, this.locator);
        XMLReader parser = this.getParser();
        ErrorHandler errorHandler2 = errorHandler = parser == null ? null : parser.getErrorHandler();
        if (errorHandler == null) {
            e.printStackTrace();
        } else {
            try {
                errorHandler.warning(e);
            }
            catch (SAXException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public T getElement() {
        try {
            return this.doGetElement();
        }
        catch (Throwable t) {
            StringWriter sb = new StringWriter();
            Locator l = this.getDocumentLocator();
            if (l != null) {
                sb.append("line ");
                sb.append(Integer.toString(l.getLineNumber()));
                sb.append(", column ");
                sb.append(Integer.toString(l.getColumnNumber()));
                sb.append(" (publicId: ");
                sb.append(l.getPublicId());
                sb.append(", systemId: ");
                sb.append(l.getSystemId());
                sb.append("), ");
            } else {
                sb.append("Unknown location, ");
            }
            sb.append(" caused by:\n");
            t.printStackTrace(new PrintWriter(sb));
            throw new RuntimeException(sb.toString());
        }
    }

    protected T doGetElement() {
        return Checks.thisMethodShouldNeverBeCalled();
    }
}

